﻿using System;
using System.Linq;
using log4net.Core;

namespace gov.va.med.vbecs.Common.Log
{
    /// <summary>
    /// Log4NetWrapper
    /// </summary>
    public class Log4NetWrapper : ILogger
    {
        private readonly log4net.ILog _logger;

        /// <summary>
        /// Log4NetWrapper
        /// </summary>
        /// <param name="type"></param>
        public Log4NetWrapper(Type type)
        {
            _logger = log4net.LogManager.GetLogger(type);
        }

        /// <summary>
        /// Log4NetWrapper
        /// </summary>
        /// <param name="loggerName"></param>
        public Log4NetWrapper(string loggerName)
        {
            _logger = log4net.LogManager.GetLogger(loggerName);
        }

        /// <summary>
        /// Debug
        /// </summary>
        /// <param name="message"></param>
        public void Debug(object message)
        {
            _logger.Debug(message);
        }

        /// <summary>
        /// IsDebugEnabled
        /// </summary>
        public bool IsDebugEnabled
        {
            get { return _logger.IsDebugEnabled; }
        }

        /// <summary>
        /// Info
        /// </summary>
        /// <param name="message"></param>
        public void Info(object message)
        {
            _logger.Info(message);
        }

        /// <summary>
        /// IsInfoEnabled
        /// </summary>
        public bool IsInfoEnabled
        {
            get { return _logger.IsInfoEnabled; }
        }

        /// <summary>
        /// Warn
        /// </summary>
        /// <param name="message"></param>
        public void Warn(object message)
        {
            _logger.Warn(message);
        }

        /// <summary>
        /// IsWarnEnabled
        /// </summary>
        public bool IsWarnEnabled
        {
            get { return _logger.IsWarnEnabled; }
        }

        /// <summary>
        /// Error
        /// </summary>
        /// <param name="message"></param>
        public void Error(object message)
        {
            _logger.Error(message);
        }

        /// <summary>
        /// Error
        /// </summary>
        /// <param name="message"></param>
        /// <param name="ex"></param>
        public void Error(object message, Exception ex)
        {
            _logger.Error(message, ex);
        }

        /// <summary>
        /// IsErrorEnabled
        /// </summary>
        public bool IsErrorEnabled
        {
            get { return _logger.IsErrorEnabled; }
        }

        /// <summary>
        /// Fatal
        /// </summary>
        /// <param name="message"></param>
        public void Fatal(object message)
        {
            _logger.Fatal(message);
        }

        /// <summary>
        /// IsFatalEnabled
        /// </summary>
        public bool IsFatalEnabled
        {
            get { return _logger.IsFatalEnabled; }
        }
    }
}
